function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 100);

T = NK_financial.dynamic_resid_tt(T, y, x, params, steady_state, it_);

T(48) = (1+T(1))^(-params(6))*T(2);
T(49) = (1-params(6))*T(2)*params(7)/T(5);
T(50) = (-(params(7)/(1+T(1))));
T(51) = getPowerDeriv(T(7),1-params(6),1);
T(52) = (1+T(1))*(-y(21))/(y(1)*y(1));
T(53) = ((1+T(1))*y(72)-y(21)*params(7))*((1+T(1))*y(72)-y(21)*params(7));
T(54) = (1+T(1))*1/y(1);
T(55) = (params(6)-1)*getPowerDeriv(y(22),1+params(29),1)/(1+params(29));
T(56) = T(9)*T(55);
T(57) = getPowerDeriv(y(22),params(29),1);
T(58) = 1/(1+T(1));
T(59) = T(58)*getPowerDeriv(T(26),1-params(2),1);
T(60) = (1+T(1))*(-y(26))/(y(3)*y(3));
T(61) = (1+T(1))*1/y(3);
T(62) = (-(T(48)*y(76)))/(y(29)*y(29));
T(63) = T(48)/y(29);
T(64) = 1/(steady_state(18));
T(65) = getPowerDeriv(y(8),params(12),1);
T(66) = T(65)/y(37);
T(67) = getPowerDeriv(T(22),1-params(5),1);
T(68) = getPowerDeriv(y(8),params(5)*params(12),1);
T(69) = (-(T(23)*T(68)));
T(70) = getPowerDeriv(y(8),params(11),1);
T(71) = T(70)/y(36);
T(72) = getPowerDeriv(T(37),1-params(4),1);
T(73) = getPowerDeriv(y(8),params(4)*params(11),1);
T(74) = (-(T(38)*T(73)));
T(75) = getPowerDeriv(y(36),params(5)*params(12),1);
T(76) = (-(T(15)*T(75)));
T(77) = T(76)/(T(16)*T(16));
T(78) = getPowerDeriv(y(36),params(12)*(params(5)-1),1);
T(79) = y(80)*T(78);
T(80) = (-(T(15)*T(79)));
T(81) = T(80)/(T(19)*T(19));
T(82) = getPowerDeriv(y(36),params(4)*params(11),1);
T(83) = (-(T(30)*T(82)));
T(84) = T(83)/(T(31)*T(31));
T(85) = getPowerDeriv(y(36),params(11)*(params(4)-1),1);
T(86) = (-(T(33)*T(85)));
T(87) = T(86)/(T(34)*T(34));
T(88) = getPowerDeriv(y(36),params(4),1);
T(89) = (-(T(15)*T(18)))/(T(19)*T(19));
T(90) = getPowerDeriv(y(80),params(4),1);
T(91) = T(90)/T(31);
T(92) = getPowerDeriv(y(80),params(4)-1,1);
T(93) = T(92)/T(34);
T(94) = getPowerDeriv(y(37),params(5),1);
T(95) = getPowerDeriv(y(81),params(5),1);
T(96) = (1+T(1))*(-y(38))/(y(9)*y(9));
T(97) = (1+T(1))*1/y(9);
T(98) = getPowerDeriv(y(40)*y(46),params(2),1);
T(99) = (-y(50))/(y(13)*y(13));
T(100) = 1/y(13);

end
